<?php
header('Content-Type: application/json');
require_once 'session_check.php';

$dbPath = __DIR__ . '/api/max.db';
try {
    $db = new PDO('sqlite:' . $dbPath);
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $id = $_GET['id'] ?? null;

    if (!$id || !is_numeric($id)) {
        http_response_code(400);
        echo json_encode(['status' => 'error', 'message' => 'ID inválido']);
        exit;
    }

    $stmt = $db->prepare("SELECT apk_url, icon_url FROM apps WHERE id = ?");
    $stmt->execute([$id]);
    $app = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$app) {
        http_response_code(404);
        echo json_encode(['status' => 'error', 'message' => 'App não encontrado']);
        exit;
    }

    echo json_encode($app);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => 'Erro no servidor: ' . $e->getMessage()]);
}